import plus
import random
from AI import vector3

import Arenas

class Hazard(object):
    def __init__(self, location):
        self.location = location
        
    
class Faller(Hazard):

    def __init__(self, a_prismatic, location = (0, 0, 0)):
        Hazard.__init__(self, location)
        #statuses: 0=off, 1=on
        self.status = 0
        self.prismatic = a_prismatic
        self.prismatic.SetAutoLock(True)
        self.prismatic.SetPowerSettings(0.002, 20)
     
            
    def Fall(self, dir):
        self.prismatic.Lock(False)
        self.prismatic.SetDirection(dir)
        

class TrapDoor(Hazard):

    def __init__(self, a_hinge, location = (0, 0, 0)):
        Hazard.__init__(self, location)
        self.hinge = a_hinge
        self.hinge.Lock(True)
        self.ready = True
        self.firesound = plus.createSound("Sounds\\hzd_trapdoor.wav", True, self.location)
        
    def __del__(self):
        plus.removeSound(self.firesound)
        
    def Trigger(self):
        if self.ready:
            plus.playSound(self.firesound)
            self.hinge.Lock(False)
            self.hinge.SetDirection(100)
            self.hinge.ApplyTorque(300)
            self.ready = False
            return True
        else: return False
        
